---
url: /dash-core-components/loading
name: Loading
description:
    "The dcc.Loading component displays a customizable loading spinner until the wrapped component has rendered."
languages:
    - python
    - julia
    - matlab
    - fsharp
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) dcc.Loading

The `dcc.Loading` component displays a customizable loading spinner until the wrapped component has rendered.

## Examples

### Basic Loading

Here's a simple example where the `Loading` component wraps the outputs for a couple of `Input` components.

- The callback for the first `Input` demonstrates the basic usage with a default spinner component.
- The callback for the second `Input` shows how even nested children will set the loading state of the wrapped component.
- There are 5 built-in spinner types.  The `dcc.Loading` that wraps the second `Input` uses `type="circle"`

{{example_tabs loading_component}}


### Delay Show and Delay Hide

To prevent the spinner from quickly flashing during rapid loading times, adjust the `delay_show` and `delay_hide` properties.

> `delay_show`: time delay (in ms) after the wrapped components enter the loading state and before the spinner is shown.
>
> `delay_hide`: the minimum time (in ms) the spinner is displayed after it's shown.
>


In this example, the callback takes about 100 milliseconds.

Try the following:
- Press the Load button with both delays at 0.  Notice the spinner briefly appearing.
- To prevent showing the spinner, increase `delay_show` to 500
- To extend the time the spinner is visible, increase `delay_hide` to 500 or more and set `delay_show` to 0.

{{example_tabs loading_delay}}


### Loading Overlay Style


By default, the spinner hides the wrapped component during loading. To make the wrapped component visible and blur the
content, you can set the following CSS in the `overlay_style` prop:

```python
dcc.Loading(
    overlay_style={"visibility":"visible", "filter": "blur(2px)"},
    # other properties
)
```

{{example_tabs loading_overlay}}


### Custom Spinner Component

Instead of using one of the built-in spinners, you can use a Dash component as the spinner. This example sets the
`custom_spinner` property to a component that includes a spinner from the Dash Bootstrap Components library, but you can use
any components to set the `custom_spinner` prop.


Note that the `type`, `fullscreen`, `debug`,  `color`, `style` and `className` properties are specific to the built-in spinner types and do
not work with custom spinner components.
 -

{{example_tabs loading_custom}}


### Target Components

Use the `target_components` property to specify which component id and component property combinations it wraps can trigger the
loading spinner. The spinner component is displayed only when one of the target component and properties enters
loading state.

`target_components` is a dictionary where the key is the component id, and the value is the property name, or a list of property names or "*"

For example, this will display the spinner only when the AgGrid's `rowData` property is being updated.

```python
app.layout=dcc.Loading(
    html.Div([
        dag.AgGrid(id="grid"),
        html.Div(id="output-div")
    ]),
    target_components={"grid": "rowData" }
)

```
This will display the spinner while any of the grid's properties are being updated:
```python
target_components ={"grid": "*"}
```

This will display the spinner when either the grid's `rowData` or `columnDefs` are being updated:
```python
target_components ={"grid": ["rowData", "columnDefs"]}
```


In this example, the `dcc.Loading` component wraps two callback outputs, but only one triggers the spinner.

{{example_tabs loading_target}}


### Manually Display Loading Spinner

Use the `display` property to manually display or hide the loading spinner. Set to "show", "hide" or "auto" (the default).


{{example_tabs loading_display}}

***


Please also check out <dccLink href="/loading-states" children="this section on loading states"/> if you want a more customizable experience.

### Limitations


Updating component properties with `set_props` in a callback does not update the loading state and is not compatible with the `dcc.Loading` component.

{{reference dcc.Loading}}