open Dash.NET.Giraffe
open Dash.NET.DCC
open Plotly.NET

let trace =
    let tmp = Trace("scatter")
    tmp?x <- [1;2;3]
    tmp?y <- [4;1;2]
    tmp

let fig =
    GenericChart.Figure.create [ trace ] (Layout())
    |> GenericChart.fromFigure
    |> GenericChart.toFigure

let layout = Graph.graph "graph" [ Graph.Attr.figure fig ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
