open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Dropdown.dropdown "demo-dropdown" [
                Dropdown.Attr.options [
                    { Label = "New York City"; Value = "NYC"; Disabled = false; Title = "New York City" }
                    { Label = "Montreal"; Value = "MTL"; Disabled = false; Title = "Montreal" }
                    { Label = "San Francisco"; Value = "SF"; Disabled = false; Title = "San Francisco" }
                ]
                Dropdown.Attr.value "NYC"
            ]
            Html.div [ Attr.id "dd-output-container" ]
        ]
    ]

let changeTextCallback =
    Callback.singleOut (
        "demo-dropdown" @. Value,
        "dd-output-container" @. Children,
        (fun (dval: string) -> "dd-output-container" @. Children => sprintf "You have selected %s" dval)
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback changeTextCallback
    |> DashApp.run args