open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET
open System


let layout = 
  Html.div [
    Attr.children [
      DatePickerSingle.datePickerSingle
             "my-date-picker-single"
             [
                DatePickerSingle.Attr.minDateAllowed  "1995-8-5"
                DatePickerSingle.Attr.maxDateAllowed "2017-9-19"
                DatePickerSingle.Attr.initialVisibleMonth  "2017-8-5"
                DatePickerSingle.Attr.date  "2017-8-25"
             ]
      Html.div [ Attr.id "output-container-date-picker-single" ];
    ]
  ]


let callback =
  Callback.singleOut(
      "my-date-picker-single" @. CustomProperty "date",
      "output-container-date-picker-single" @. Children,
      (fun (date : string)->
          
          let prefix = "You have selected: "

          let selectedDateLabel = match date with
                                  | null ->  prefix
                                  | _    ->  prefix + DateTime.Parse(date).ToString("MMM dd, yyyy")


          let label = if selectedDateLabel = prefix 
                      then "Select a date to see it displayed here" 
                      else selectedDateLabel
          
          "output-container-date-picker-single" @. Children => label
      ))
      


[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args