open Giraffe
open Dash.NET
open Dash.NET.DCC
open Dash.NET.Giraffe
open Microsoft.Extensions.Logging

let layout =
    Html.div [
        Attr.children [
            Textarea.textarea "textarea_id" [
                Textarea.Attr.value "Copy and paste here"
                Textarea.Attr.style [
                    StyleProperty ("height", 100)
                ]
            ]
            Clipboard.clipboard "clipboard" [
                Clipboard.Attr.targetId "textarea_id"
                Clipboard.Attr.title "copy"
                Clipboard.Attr.style [
                    StyleProperty ("display", "inline-block")
                    StyleProperty ("fontSize", 20)
                    StyleProperty ("verticalAlign", "top")
                ]
            ]
        ]
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
