open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Location.location "url" [ Location.Attr.pathname "/" ]
            Html.div [ Attr.id "layout-div" ]
            Html.div [ Attr.id "content" ]
        ]
    ]

let updatePageCallback =
    Callback.singleOut (
        "url" @. (CustomProperty "pathname"),
        "content" @. Children,
        fun (pathname: string) -> 
            let layout =
                Html.div [
                    Attr.children [
                        Input.input "input" [
                            Input.Attr.value "Hello World"
                        ]
                        Html.div [ Attr.id "output" ]
                    ]
                ]
            "content" @. Children => layout
        , PreventInitialCall = false
    )

let updateOutputCallback =
    Callback.singleOut (
        "input" @. Value,
        "output" @. Children,
        fun (value: string) -> 
            "output" @. Children => value
        , PreventInitialCall = true
    )

let updateLayoutCallback =
    Callback.singleOut (
        "input" @. Value,
        "layout-div" @. Children,
        fun (value: string) -> 
            "layout-div" @. Children => value
        , PreventInitialCall = true
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updatePageCallback
    |> DashApp.addCallback updateOutputCallback
    |> DashApp.addCallback updateLayoutCallback
    |> DashApp.run args