open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Html.button [ Attr.id "button_1"; Attr.children "Execute callbacks"; Attr.n_clicks 0 ]
            Html.div [ Attr.id "output_1"; Attr.children "callback not executed" ]
            Html.div [ Attr.id "output_2"; Attr.children "callback not executed" ]
        ]
    ]

let changeTextCallback =
    Callback.multiOut (
        "button_1" @. (CustomProperty "n_clicks"),
        [ "output_1" @. Children
          "output_2" @. Children ],
        fun (nClicks: int) -> 
            match nClicks with
            | 0 -> 
                [ "output_1" @. Children => sprintf "n_clicks is None"
                  "output_2" @. Children => sprintf "n_clicks is None" ]
            | _ ->
                [ "output_1" @. Children => sprintf "n_clicks is %d" nClicks
                  "output_2" @. Children => sprintf "n_clicks is %d" nClicks ]
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback changeTextCallback
    |> DashApp.run args