---
url: /installation
name: Installation
description:
    "How to install and upgrade Dash"
icon: tools.svg
languages:
  - python
  - r
  - fsharp
  - matlab
  - julia
---
# ![](/assets/images/language_icons/f-sharp_50px.svg) Dash Installation





### Option 1: F# scripting (recommended)

You can execute the source code examples as F# scripts.
You will not have to install anything, but have to include the following NuGet references at the top of your script.
This will use the latest (stable) development version of `Dash.NET`.

```fsharp
#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"
```

### Option 2: Dash project template

Alternatively you can install a `Dash.NET` project template:
```bash
dotnet new -i Dash.NET.Template::*
```

Then create a new project (which will contain some sample `Dash.NET` code in `Program.fs`):
```bash
dotnet new dash
```

### Option 3: From scratch

A second alternative is to create an empty console project:

```bash
dotnet new console -lang F#
```

Then add the latest (stable) development version of `Dash.NET` package to the project:
```bash
dotnet add package Dash.NET
```

This also brings along the `Plotly.NET` graphing
library. This library is
under active development, so check the package version and update  frequently.








These docs are using `Dash.NET` version `{{eval dash.__version__` ||julia `1.0.0` ||r `0.9.1`}}.

This version supports .NET 5.0.

### FSharp.Data

[FSharp.Data](https://fsprojects.github.io/FSharp.Data/) is used in many of our examples.

When required, you can add a reference to it in your F# script:
```fsharp
#r "nuget: FSharp.Data"
```

If you are using a F# project, you can add the package:
```bash
dotnet add package FSharp.Data
```


{{oss {{dash-club}} }}



{{oss
{{import /reusable_components/WorkspaceBlurb.md}}
}}
