open Dash.NET
open Microsoft.Extensions.Logging
open Giraffe.Core

let dslLayout = Html.div []

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.appendScripts [ "https://www.google-analytics.com/analytics.js" ]
    |> Giraffe.DashApp.appendCSSLinks [ "https://codepen.io/chriddyp/pen/bWLwgP.css" ]
    |> Giraffe.DashApp.run args 
        { HostName = "localhost"
          LogLevel = LogLevel.Debug
          ErrorHandler = ((fun ex ->  ex.Message) >> text) }