open Dash.NET

let input1 = "input1"
let input2 = "input2"
let output = "output"
let outputTarget = output @. Children

let externalStylesheets = [ "https://codepen.io/chriddyp/pen/bWLwgP.css" ]

let layout =
    Html.div [
        Attr.children [
            Html.i [
                Attr.children [
                    Html.text """Try typing in input 1 & 2, and observe how debounce
                    is impacting the callbacks. Press Enter and/or Tab key in 
                    Input 2 to cancel the delay"""
                ]
            ]
            Html.br []
            Input.input input1 [
                Input.Attr.inputType InputType.Text
                Input.Attr.placeholder ""
                Input.Attr.value ""
                Input.Attr.style [ StyleProperty ("marginRight", "10px") ]
            ]
            Input.input input2 [
                Input.Attr.inputType InputType.Text
                Input.Attr.placeholder ""
                Input.Attr.value ""
                Input.Attr.debounce true
            ]
            Html.div [ Attr.id output ]
        ]
    ]

let callback =
    Callback.singleOut (
        [ input1 @. Value
          input2 @. Value ],
        outputTarget,
        (fun input1 input2 ->
            outputTarget => sprintf "Input 1 \"%s\" and Input 2 \"%s\"" input1 input2),
        PreventInitialCall = true
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.appendCSSLinks externalStylesheets
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args
