open Dash.NET.Giraffe
open Dash.NET.DCC

let layout =
    Graph.graph "graph" [
        Graph.Attr.figure
            {|
                data = [
                    {| x = [1; 2; 3]; y = [4; 1; 2]; ``type`` = "bar"; name = "SF" |}
                    {| x = [1; 2; 3]; y = [2; 4; 5]; ``type`` = "bar"; name = "Montréal" |}
                ]
                layout = {| title = "Dash Data Visualization" |}
            |}
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
