open Dash.NET
open Dash.NET.DCC

let initialValue = "1+1=2"

let dslLayout = 
    Html.div [
        Attr.children [
            Html.text "Remember this important info:"
            Html.br []
            Input.input "important-info" [
                Input.Attr.value initialValue
                Input.Attr.persistence true
            ]
            Html.button [
                Attr.id "clear-info"
                Attr.children "Forget it!"
            ]
        ]
    ]

let updateInfo =
    Callback.multiOut(
        [ "clear-info" @. N_Clicks ],
        [ "important-info" @. Value ],
        fun n ->
            if n then [ "important-info" @. Value => initialValue ] else []
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.addCallback updateInfo
    |> Giraffe.DashApp.run args (Giraffe.DashGiraffeConfig.initDebug "localhost")