---
url: /faqs
name: FAQs
description: "If you have read through the tutorial and still have questions or are encountering unexpected behaviour, this page may be useful."
icon: question.svg
languages:
  - python
  - julia
  - r
  - fsharp
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) Frequently Asked Questions

**Q:** _How can I customize the appearance of my Dash app?_

**A:** Dash apps are rendered in the browser as modern standards-compliant
web apps. This means that you can use CSS to style your Dash app as you
would standard HTML.

All `Dash.NET.Html` components support inline CSS styling through a `style`
attribute. An external CSS stylesheet can also be used to style
`Dash.NET.Html` components and `Dash.NET.DCC` components by targeting the ID or
class names of your components. Both `Dash.NET.Html` components and
most of the `Dash.NET.DCC` components accept the attribute `className`, which corresponds
to the HTML element attribute `class`.

To use an external stylesheet, first make sure any local CSS files are in your `WebRoot` folder, then use the `DashApp.appendCSSLinks [...]` chainable method when initializing your Dash app:

```fsharp
let myDashApp =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.appendCSSLinks [
        "main.css" // local css
        "https://some-website.com/external.min.css" // external css
    ]
```



---

**Q:** _How can I add JavaScript to my Dash app?_

**A:** To use an external stylesheet, first make sure any local javascript files are in your `WebRoot` folder, then use the `DashApp.appendScripts [...]` chainable method when initializing your Dash app:

```fsharp
let myDashApp =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.appendScripts [
        "main.js" // local javascript
        "https://some-website.com/external.min.js" // external javascript
    ]
```



---









**Q:** _Can I use jQuery with Dash?_

**A:** For the most part, you can't. Dash uses React to render your app on
the client browser. React is fundamentally different to jQuery in that it
makes use of a virtual DOM (Document Object Model) to manage page
rendering. Since jQuery doesn't speak React's virtual DOM, you can't use
any of jQuery's DOM manipulation facilities to change the page layout,
which is frequently why one might want to use jQuery. You can however use
parts of jQuery's functionality that do not touch the DOM, such as
registering event listeners to cause a page redirect on a keystroke.

In general, if you are looking to add custom clientside behavior in your
application, we recommend encapsulating that behavior in a [custom Dash component](/build-your-own-components).

---



**Q:** _I have more questions! Where can I go to ask them?_

**A:** The [Dash Community forums](https://community.plotly.com/c/dash) is full
of people discussing Dash topics, helping each other with questions, and
sharing Dash creations. Jump on over and join the discussion.
