open Dash.NET
open Microsoft.Extensions.Logging
open Giraffe.Core
open Giraffe.ViewEngine

let dslLayout = Html.div []

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.mapIndex (fun index ->
        {index with Renderer = 
            rawText """
                var renderer = new DashRenderer({
                    request_pre: (payload) => {
                        // print out payload parameter
                        console.log(payload);
                    },
                    request_post: (payload, response) => {
                        // print out payload and response parameter
                        console.log(payload);
                        console.log(response);
                    }
                })
            """})
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.run args 
        { HostName = "localhost"
          LogLevel = LogLevel.Debug
          ErrorHandler = ((fun ex ->  ex.Message) >> text) }