open Dash.NET.Giraffe
open Dash.NET.DashTable

let money = FormatTemplate.money(2u)
let percentage = FormatTemplate.percentage(2u)

let columns = [|
    DataTable.Column.init("Account", "account")
    DataTable.Column.init("Balance", "balance", columnType = DataTable.ColumnType.Numeric, format=money)
    DataTable.Column.init("Rate", "rate", columnType = DataTable.ColumnType.Numeric, format=percentage)
|]

let data = [
    box {| account = "A"; balance = 522.3199; rate = 0.139 |}
    box {| account = "B"; balance = 1607.999; rate = 0.1044 |}
    box {| account = "C"; balance = (-228.4199); rate = 0.199 |}
]

let layout =
    DataTable.dataTable "datatable" [
        DataTable.Attr.columns columns
        DataTable.Attr.data data
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
