open Dash.NET.Giraffe
open Dash.NET.DashTable
open Dash.NET.Html

let columns = [
    [|
        DataTable.Column.init("Default", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init())
        DataTable.Column.init("No Symbol", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Symbol.No))
        DataTable.Column.init("$ Symbol", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper().symbol(Symbol.Yes))
        DataTable.Column.init("@ Symbol / Locale prefix", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper().symbol(Symbol.Yes).symbolPrefix("@"))
        DataTable.Column.init("@ Symbol / Locale prefix+suffix", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper().symbol(Symbol.Yes).symbolPrefix("@").symbolSuffix("*"))
    |]
    [|
        DataTable.Column.init("Binary", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Binary))
        DataTable.Column.init("Octal", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Octal))
        DataTable.Column.init("Hex", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Hex))
        DataTable.Column.init("Custom", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(locale=DataTable.Locale.init(symbol=["@"; "*"]), specifier="$"))
    |]
]

let data =
    [ 123.1; 123.12; 1234.123; 12345.12 ]
    |> List.map (fun v -> box {| a = v |})

let layout =
    Html.div [
        Attr.children (
            columns
            |> List.mapi (fun i columns ->
                Html.div [
                    Attr.children [
                        DataTable.dataTable (sprintf "datatable_%i" i) [
                            DataTable.Attr.columns columns
                            DataTable.Attr.data data
                        ]
                        Html.br []
                    ]
                ]
            )
        )
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
