open Dash.NET.Giraffe
open Dash.NET.DashTable
open Dash.NET.Html

let columns = [
    [|
        DataTable.Column.init("No precision", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init())
        DataTable.Column.init("Default", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u))
        DataTable.Column.init("Fixed", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Fixed))
        DataTable.Column.init("Decimal", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Decimal))
        DataTable.Column.init("Integer", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=DecimalInteger))
        DataTable.Column.init("Decimal/Exponent", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=DecimalOrExponent))
        DataTable.Column.init("Decimal SI", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=DecimalSiPrefix))
        DataTable.Column.init("Exponent", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Exponent))
    |]
    [|
        DataTable.Column.init("Percentage", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Percentage))
        DataTable.Column.init("Rounded Percentage", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=PercentageRounded))
        DataTable.Column.init("Binary", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Scheme.Binary))
        DataTable.Column.init("Octal", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Scheme.Octal))
        DataTable.Column.init("hex", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=LowerCaseHex))
        DataTable.Column.init("HEX", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=UpperCaseHex))
        DataTable.Column.init("Unicode", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=2u, scheme=Unicode))
    |]
    [|
        DataTable.Column.init("4 decimals", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=4u, scheme=Fixed))
        DataTable.Column.init("4 decimals / trimmed", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(precision=4u, scheme=Fixed, trim=Trim.Yes))
        DataTable.Column.init("Custom 4 decimals / trimmed", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier=".4~f"))
    |]
]

let data =
    [ 123.1; 123.12; 1234.123; 12345.12 ]
    |> List.map (fun v -> box {| a = v |})

let layout =
    Html.div [
        Attr.children (
            columns
            |> List.mapi (fun i columns ->
                Html.div [
                    Attr.children [
                        DataTable.dataTable (sprintf "datatable_%i" i) [
                            DataTable.Attr.columns columns
                            DataTable.Attr.data data
                        ]
                        Html.br []
                    ]
                ]
            )
        )
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
