open Dash.NET.Giraffe
open Dash.NET.DashTable
open Dash.NET.Html

let columns = [
    [|
        DataTable.Column.init("Symbol", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Symbol.Yes))
        DataTable.Column.init("Symbol prefix", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Symbol.Yes, symbolPrefix="CAD$ "))
        DataTable.Column.init("Symbol suffix", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(symbol=Symbol.Yes, symbolSuffix=" CAD$"))
        DataTable.Column.init("Symbol custom", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier="$", locale=DataTable.Locale.init(symbol = [ "@"; "*" ])))
    |]
    [|
        DataTable.Column.init("Decimal", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(decimalDelimiter=':').scheme("f").precision(2u))
        DataTable.Column.init("Custom decimal", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier=".2f", locale=DataTable.Locale.init(decimal=':')))
        DataTable.Column.init("Group", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(groupDelimiter=':', group=Group.Yes, groups=[2u]))
        DataTable.Column.init("Custom group", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier=",", locale=DataTable.Locale.init(group=':', grouping=[2u])))
    |]
    [|
        DataTable.Column.init("Custom numerals", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(locale=DataTable.Locale.init(numerals=["0"; "AA"; "b"; "CC"; ""; ""; ""; "77"; "88"; "99"])))
        DataTable.Column.init("Percent symbol", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier=".2%", locale=DataTable.Locale.init(percent="@")))
        DataTable.Column.init("Group 4 digits", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.init(specifier=",.0f", locale=DataTable.Locale.init(separate4digits=false)))
        DataTable.Column.init("SI", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(siPrefix=Milli).precision(0u))
        DataTable.Column.init("SI+space", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(siPrefix=Milli, symbol=Symbol.Yes, symbolSuffix=" ").precision(0u))
        DataTable.Column.init("Explicit SI", "a", columnType=DataTable.ColumnType.Numeric,
                        format=Format.helper(siPrefix=Explicit (10. ** -3.)).precision(0u))
    |]
]

let data =
    [ 123; 123; 1234; 12345; 123456789 ]
    |> List.map (fun v -> box {| a = v |})

let layout =
    Html.div [
        Attr.children (
            columns
            |> List.mapi (fun i columns ->
                Html.div [
                    Attr.children [
                        DataTable.dataTable (sprintf "datatable_%i" i) [
                            DataTable.Attr.columns columns
                            DataTable.Attr.data data
                        ]
                        Html.br []
                    ]
                ]
            )
        )
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
