open Dash.NET.Suave
open Dash.NET.Html
open Dash.NET.DCC
open Dash.NET

let layout = 
 Html.div [
   Attr.children [
     Textarea.textarea "simple-textarea" [ 
             Textarea.Attr.value "Textarea content initialized\nwith multiple lines of text";
             Textarea.Attr.style [StyleProperty("width", "100%"); StyleProperty("height", 300)]
         ]
     Html.button [ Attr.id "example-button"; Attr.typeSubmit; Attr.children "Submit"]
     Html.div [ Attr.id "textarea-example-output"; Attr.style [Css.whiteSpacePreLine ]; ];
   ]
 ]

let callback =
 Callback.singleOut(
      "example-button" @. N_Clicks,
     "textarea-example-output" @. Children,
     (fun (n_clicks : float) (value : string) -> "textarea-example-output" @. Children => if n_clicks>0.0 then "You have entered" + value else ""),
     State = [
      "simple-textarea" @. Value
        ]
     

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.addCallback callback
|> DashApp.run [||] { hostname = "localhost"
  ; ip = "127.0.0.1"
  ; port = 8000 
  ; errorHandler = Suave.Web.defaultErrorHandler }

