---
url: /dash-core-components/slider
name: Slider
description:
    "The dcc.Slider component lets users select a single value between two pre-set values."
languages:
    - python
    - julia
    - r
    - matlab
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) dcc.Slider

`dcc.Slider` is a component for rendering a slider. Users interact with a `dcc.Slider` by selecting areas on the *rail* or by dragging the *handle*.

The points displayed on a slider are called `marks`. They are autogenerated if not explicitly provided or turned off.

## Examples

Find a few usage examples below.



### Simple Slider Example

An example of a simple slider tied to a callback. The callback takes the slider's currently selected value and outputs it to a `html.Div`.

{{example slider_simple }}

` are equivalent:

```
dcc.Slider(0, 20, 5, value=10, id='my-slider')
```

```
dcc.Slider(min=0, max=20, step=5, value=10, id='my-slider')
```

```
dcc.Slider(id='my-slider', value=10, min=0, max=20, step=5)
```

```
dcc.Slider(min=0, max=20, step=5, value=10, id='my-slider')
```

### Auto Generated Marks

By default, the `dcc.Slider` component adds `marks` if they are not specified, as in the example above. It uses the `min` and `max` and and the marks correspond to the `step` if you use one.

If you don't supply `step`, `Slider` automatically calculates a step and adds around five marks. Labels for autogenerated marks are SI unit formatted.

{{example slider_without_step}}

### Custom Marks

You can also define marks. If slider `marks` are defined and `step` is set to `None` then the slider will only be
able to select values that have been predefined by the `marks`. Note that the default is
`step=1`, so you must explicitly specify `None` to get this behavior. `marks` is a `dict`
where the keys represent the numerical values and the values represent their labels.

{{example slider_marks_steps }}

### Turn Off Marks

You can turn off slider marks by setting `marks=None`:

{{example slider_turn_off_marks}}

}}

` then the slider will only be
able to select values that have been predefined by the `marks`. `marks` is a ``
where the keys represent the numerical values and the values represent their labels.

{{example slider_marks_steps }}

}}


### Included and Styling Marks

By default, `included=`, meaning the rail trailing the handle will be highlighted. To
have the handle act as a discrete value, set `included=`. To style `marks`, include a
style CSS attribute alongside the key value.

{{example slider_included }}

{{example slider_included_2 }}


### Non-Linear Slider and Updatemode




{{example slider_updatemode }}

### Slider Tooltips

The `tooltips` property can be used to display the current value. The `placement` parameter controls
the position of the tooltip i.e. 'left', 'right', 'top', 'bottom'. If `always_visible=True` is used, then
the tooltips will show always, otherwise it will only show when hovered upon.

{{example slider_tooltip}}

#### Styling Tooltips

*New in Dash 2.15*

You can customize the style of tooltips with the `tooltip.style` parameter. This accepts a dictionary of styles to apply. In this example, we set the text color and font size.

{{example slider_styles}}


#### Transforming Tooltip Values

*New in Dash 2.15*

You can transform the value displayed on a tooltip using a JavaScript function by specifying the function name with the `tooltip.transform` parameter. 

To make a custom function available in your app, add it to a file in your app's assets folder. The function needs to be available in the `window.dccFunctions` namespace.

In this example, we have a function that converts temperatures in Fahrenheit to Celsius. This function is saved in `assets/tooltip.js`:

```
window.dccFunctions = window.dccFunctions || {};
window.dccFunctions.temperatureInCelsius = function(value) {
     return ((value - 32) * 5/9).toFixed(2);
}
```

We then pass this function name to the `tooltip.transform` parameter:

{{example slider_transform}}

#### Formatting Tooltips

*New in Dash 2.15*

You can customize the text displayed on tooltips using the `tooltip.template` parameter. This accepts a string, which must contain `{value}`. The `{value}` will be replaced with the string representation of the tooltip value, or with the value returned by a transform function if one was specified using `tooltip.transform` (see the previous section).

{{example slider_format}}



***

{{reference dcc.Slider}}
