open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET
open System
open System.Threading


let layout =
    Html.div [ Attr.children [ Input.input "loading-input-1" [ Input.Attr.value "Input triggers local spinner" ]
                               Loading.loading
                                   "loading-1"
                                   [ Loading.Attr.loadingType Loading.LoadingType.Default
                                     Loading.Attr.children [ Html.div [ Attr.id "loading-output-1" ] ] ]
                               Html.div [ Attr.children [ Input.input
                                                              "loading-input-2"
                                                              [ Input.Attr.value "Input triggers nested spinner" ]
                                                          Loading.loading
                                                              "loading-2"
                                                              [ Loading.Attr.loadingType Loading.LoadingType.Circle
                                                                Loading.Attr.children [ Html.div [ Attr.id
                                                                                                       "loading-output-2" ] ] ]

                                                           ] ] ] ]

let sleep () =
    TimeSpan.FromSeconds 1.0 |> Thread.Sleep

let callback1 =
    Callback.singleOut (
        "loading-input-1" @. Value,
        "loading-output-1" @. Children,
        (fun (value: string) ->
            sleep ()
            "loading-output-1" @. Children => value)
    )

let callback2 =
    Callback.singleOut (
        "loading-input-2" @. Value,
        "loading-output-2" @. Children,
        (fun (value: string) ->
            sleep ()
            "loading-output-2" @. Children => value)
    )



[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback1
    |> DashApp.addCallback callback2
    |> DashApp.run args