open Dash.NET

let options: DropdownOption list = [
    {Label = "New York City"; Value = "NYC"; Disabled = false; Title = "New York City"}
    {Label = "Montreal"; Value = "MTL"; Disabled = false; Title = "Montreal"}
    {Label = "San Francisco"; Value = "SF"; Disabled = false; Title = "San Francisco"}
]

let dslLayout = 
    Html.div [
        Attr.children [
            Html.div [
                Attr.children [
                    Html.text "Single dynamic Dropdown"
                    Dropdown.dropdown "my-dynamic-dropdown" [
                        Dropdown.Attr.searchable true
                        Dropdown.Attr.searchValue ""
                        Dropdown.Attr.options []
                    ]
                ]
            ]
            Html.div [
                Attr.children [
                    Html.text "Multi dynamic Dropdown"
                    Dropdown.dropdown "my-multi-dynamic-dropdown" [
                        Dropdown.Attr.searchable true
                        Dropdown.Attr.searchValue ""
                        Dropdown.Attr.options []
                        Dropdown.Attr.value ""
                        Dropdown.Attr.multi true
                    ]
                ]
            ]
        ]
    ]

let updateOptionsCallback =
    Callback.singleOut (
        "my-dynamic-dropdown" @. (CustomProperty "search_value"),
        "my-dynamic-dropdown" @. (CustomProperty "options"),
        fun (sval: string) -> 
            "my-dynamic-dropdown" @. (CustomProperty "options") => (
                options 
                |> List.filter (fun o -> (string o.Label).Contains sval)
            )
        , PreventInitialCall = false
    )

let updateMultiOptionsCallback =
    Callback.singleOut (
        "my-multi-dynamic-dropdown" @. (CustomProperty "search_value"),
        "my-multi-dynamic-dropdown" @. (CustomProperty "options"),
        fun (sval: string) (dval: string) -> 
            "my-multi-dynamic-dropdown" @. (CustomProperty "options") => (
                options 
                |> List.filter (fun o -> 
                    (string o.Label).Contains sval || dval.Contains (string o.Value)
                )
            )
        , State = ["my-multi-dynamic-dropdown" @. (CustomProperty "value")]
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updateOptionsCallback
    |> DashApp.addCallback updateMultiOptionsCallback
    |> DashApp.run args