open Dash.NET.Html
open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET
open System


let layout = 
  Html.div [
    Attr.children [
      DatePickerRange.datePickerRange
             "my-date-picker-range"
             [
                DatePickerRange.Attr.minDateAllowed  "1995-8-5"
                DatePickerRange.Attr.maxDateAllowed "2017-9-19"
                DatePickerRange.Attr.initialVisibleMonth  "2017-8-5"
                DatePickerRange.Attr.endDate  "2017-8-25"
             ]
      Html.div [ Attr.id "output-container-date-picker-range" ];
    ]
  ]


let callback =
  Callback.singleOut(
      [
        "my-date-picker-range" @. CustomProperty "start_date"
        "my-date-picker-range" @. CustomProperty "end_date" 
      ],
      "output-container-date-picker-range" @. Children,
      (fun (startDate : string) (endDate: string) ->
          
          let prefix = "You have selected: "

          let startLabel = match startDate with
                           | null ->  prefix
                           | _    ->  prefix + DateTime.Parse(startDate).ToString("MMM dd, yyyy") + " | "


          let endLabel  = match endDate with
                           | null ->  startLabel
                           | _    ->  startLabel + "End Date: "  + DateTime.Parse(endDate).ToString("MMM dd, yyyy")

          let label = if endLabel = prefix 
                      then "Select a date to see it displayed here" 
                      else endLabel
          
          "output-container-date-picker-range" @. Children => label
      ))


[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args