open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Input.input "input-1-state" [ 
                Input.Attr.inputType InputType.Text
                Input.Attr.value "Montreal" 
            ]
            Input.input "input-2-state" [ 
                Input.Attr.inputType InputType.Text
                Input.Attr.value "Canada" 
            ]
            Html.button [
                Attr.id "submit-button-state"
                Attr.n_clicks 0
                Attr.children "Submit"
            ]
            Html.div [Attr.id "output-state"]
        ]
    ]

let setOutputDivValue =
    Callback.singleOut (
        "submit-button-state" @. (CustomProperty "n_clicks"),
        "output-state" @. (CustomProperty "children"),
        fun nClicks input1 input2 -> 
            "output-state" @. (CustomProperty "children") 
                => sprintf "The button has been pressed %s times, Input 1 is %s, Input 2 is %s" nClicks input1 input2
        , State = 
            [ CallbackState.create("input-1-state", "value")
              CallbackState.create("input-2-state", "value") ]
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback setOutputDivValue
    |> DashApp.run args