open Dash.NET
open System

let dslLayout = 
    Html.div [
        Attr.children [
            Html.button [ 
                Attr.id "show-secret"
                Attr.children "Click here to see the content" 
            ]
            Html.div [ Attr.id "body-div" ]
        ]
    ]

let updateOutputsCallback =
    Callback.multiOut (
        "show-secret" @. (CustomProperty "n_clicks"),
        [ "body-div" @. Children ],
        fun (nClicks: Nullable<int>) -> 
            match nClicks |> Option.ofNullable with
            | None -> []
            | Some n -> ["body-div" @. Children => "Elephants are the only animal that can't jump"]
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updateOutputsCallback
    |> DashApp.run args