open Dash.NET
open Dash.NET.DCC
open Plotly.NET
open Newtonsoft.Json

let xDataA = [1;2]
let yDataA = [1;2]
let fruitA = ["apple"; "apple"]
let xDataB = [1;2]
let yDataB = [3;4]
let fruitB = ["orange"; "orange"]

let fig = 
    [ Chart.Scatter(xDataA, yDataA, StyleParam.Mode.Markers, Color = Color.fromKeyword Red, Labels = fruitA)
      Chart.Scatter(xDataB, yDataB, StyleParam.Mode.Markers, Color = Color.fromKeyword Orange, Labels = fruitB) ]
    |> Chart.combine
    |> GenericChart.toFigure

let dslLayout = 
    Html.div [
        Attr.children [
            Graph.graph "basic-interactions" [
                Graph.Attr.figure fig
            ]

            Html.div [
                Attr.className "row"
                Attr.children [
                    Html.div [
                        Attr.className "three columns"
                        Attr.children [
                            Markdown.markdown "hover-data-head" [
                                Markdown.Attr.children "
                                    **Hover Data**
                                    
                                    Mouse over values in the graph.
                                "
                            ]
                            Html.pre [
                                Attr.id "hover-data"
                                Attr.style [ 
                                    Css.border ("thin", Feliz.borderStyle.solid, "lightgrey")
                                    Css.overflowXScroll
                                ]
                            ]
                        ]
                    ]
                    Html.div [
                        Attr.className "three columns"
                        Attr.children [
                            Markdown.markdown "click-data-head" [
                                Markdown.Attr.children "
                                    **Click Data**
                                    
                                    Click on points in the graph.
                                "
                            ]
                            Html.pre [
                                Attr.id "click-data"
                                Attr.style [ 
                                    Css.border ("thin", Feliz.borderStyle.solid, "lightgrey")
                                    Css.overflowXScroll
                                ]
                            ]
                        ]
                    ]
                    Html.div [
                        Attr.className "three columns"
                        Attr.children [
                            Markdown.markdown "selected-data-head" [
                                Markdown.Attr.children "
                                    **Selection Data**
                                    
                                    Choose the lasso or rectangle tool in the graph's menu
                                    bar and then select points in the graph.
                                    
                                    Note that if `layout.clickmode = 'event+select'`, selection data also
                                    accumulates (or un-accumulates) selected data if you hold down the shift
                                    button while clicking.
                                "
                            ]
                            Html.pre [
                                Attr.id "selected-data"
                                Attr.style [ 
                                    Css.border ("thin", Feliz.borderStyle.solid, "lightgrey")
                                    Css.overflowXScroll
                                ]
                            ]
                        ]
                    ]
                    Html.div [
                        Attr.className "three columns"
                        Attr.children [
                            Markdown.markdown "relayout-data-head" [
                                Markdown.Attr.children "
                                    **Zoom and Relayout Data**
                                    
                                    Click and drag on the graph to zoom or click on the zoom
                                    buttons in the graph's menu bar.
                                    Clicking on legend items will also fire
                                    this event.
                                "
                            ]
                            Html.pre [
                                Attr.id "relayout-data"
                                Attr.style [ 
                                    Css.border ("thin", Feliz.borderStyle.solid, "lightgrey")
                                    Css.overflowXScroll
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ]

let hoverDataCallback =
    Callback.singleOut(
        "basic-interactions" @. (CustomProperty "hoverData"),
        "hover-data" @. Children,
        fun (data: obj) -> 
            "hover-data" @. Children => JsonConvert.SerializeObject(data, Formatting.Indented)

    )

let clickDataCallback =
    Callback.singleOut(
        "basic-interactions" @. (CustomProperty "clickData"),
        "click-data" @. Children,
        fun (data: obj) -> 
            "click-data" @. Children => JsonConvert.SerializeObject(data, Formatting.Indented)
    )

let selectedDataCallback =
    Callback.singleOut(
        "basic-interactions" @. (CustomProperty "selectedData"),
        "selected-data" @. Children,
        fun (data: obj) -> 
            "selected-data" @. Children => JsonConvert.SerializeObject(data, Formatting.Indented)
    )

let relayoutDataCallback =
    Callback.singleOut(
        "basic-interactions" @. (CustomProperty "relayoutData"),
        "relayout-data" @. Children,
        fun (data: obj) -> 
            "relayout-data" @. Children => JsonConvert.SerializeObject(data, Formatting.Indented)
    )

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.appendCSSLinks ["https://codepen.io/chriddyp/pen/bWLwgP.css"]
    |> Giraffe.DashApp.addCallbacks [
        hoverDataCallback
        clickDataCallback
        selectedDataCallback
        relayoutDataCallback
    ]
    |> Giraffe.DashApp.run args (Giraffe.DashGiraffeConfig.initDebug "localhost")