// Run this app with `dotnet fsi app.fsx` and
// visit http://127.0.0.1:8050/ in your web browser.

#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"
#r "nuget: FSharp.Data"

open Plotly.NET
open Dash.NET
open Dash.NET.Suave
open Dash.NET.DCC
open FSharp.Data

[<Literal>]
let Csv = "https://gist.githubusercontent.com/chriddyp/5d1ea79569ed194d432e56108a04d188/raw/a9f9e8076b837d541398e999dcbac2b2826a81f8/gdp-life-exp-2007.csv"
type CsvData = CsvProvider<Csv>
let csv = CsvData.Load(Csv).Cache()
let toLabel (r:CsvData.Row) =
    sprintf "<br>%s=%s<br>%s=%s<br>%s=%.3f"
        (nameof(r.Country))
        r.Country
        (nameof(r.Continent))
        r.Continent
        (nameof(r.Population))
        r.Population


let fig =
    let refRow = csv.Rows |> Seq.head

    Chart.Bubble(
        csv.Rows |> Seq.map (fun r -> r.``Gdp per capita``),
        csv.Rows |> Seq.map (fun r -> r.``Life expectancy``),
        csv.Rows |> Seq.map (fun r -> r.Population / (decimal 10_000_000)),
        Labels = (csv.Rows |> Seq.map toLabel)
    )
    |> Chart.withX_Axis(
        Axis.LinearAxis.init(
            AxisType = StyleParam.AxisType.Log,
            Title = nameof(refRow.``Gdp per capita``)
        )
    )
        |> Chart.withY_Axis(
            Axis.LinearAxis.init(
                Title = nameof(refRow.``Life expectancy``)
            )
        )
    |> GenericChart.toFigure

let layout =
    Html.div [
        Attr.children [
            Graph.graph "life-exp-vs-gdp" [
                Graph.Attr.figure fig
            ]
        ]
    ]

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.run [||]
    { hostname = "localhost";
      ip = "127.0.0.1"
      port = 8050
      errorHandler = Suave.Web.defaultErrorHandler }
