// Run this app with `dotnet fsi app.fsx` and
// visit http://127.0.0.1:8050/ in your web browser.

#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"

open Dash.NET
open Dash.NET.Suave
open Dash.NET.DCC

let layout =
    Markdown.markdown "markdown" [
        Markdown.Attr.children """
            ### Dash and Markdown

            Dash apps can be written in Markdown.
            Dash uses the [CommonMark](http://commonmark.org/)
            specification of Markdown.
            Check out their [60 Second Markdown Tutorial](http://commonmark.org/help/)
            if this is your first introduction to Markdown!
        """
    ]

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.run [||]
    { hostname = "localhost";
      ip = "127.0.0.1"
      port = 8050
      errorHandler = Suave.Web.defaultErrorHandler }
