open Dash.NET
open Microsoft.Extensions.Logging
open Giraffe.Core

let dslLayout =
    Html.div [
        Attr.children [
            Html.div [
                Attr.className "app-header"
                Attr.children [
                    Html.div [
                        Attr.className "app-header--title"
                        Attr.children "Plotly Dash"
                    ]
                ]
            ]
            Html.div [
                Attr.children [
                    Html.h1 [
                        Attr.children "Overview"
                    ]
                    Html.div [
                        Attr.children
                            "This is an example of a simple Dash app with
                            local, customized CSS."
                    ]
                ]
            ]
        ]
    ]

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.appendScripts [ "custom-script.js" ]
    |> Giraffe.DashApp.appendCSSLinks [ "typography.css"; "header.css" ]
    |> Giraffe.DashApp.run args
        { HostName = "localhost"
          LogLevel = LogLevel.Debug
          ErrorHandler = ((fun ex ->  ex.Message) >> text) }