open Dash.NET
open Microsoft.Extensions.Logging
open Giraffe.Core

let dslLayout = 
    Html.div [
        Attr.children [
            Html.img [
                Attr.src "/assets/image.png"
            ]
        ]
    ]

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.run args {HostName = "localhost"; LogLevel = LogLevel.Debug; ErrorHandler = ((fun ex ->  ex.Message) >> text)}