open Dash.NET
open Microsoft.Extensions.Logging
open Giraffe.Core
open System.IO
open System

let b64Image = File.ReadAllBytes >> Convert.ToBase64String

let dslLayout = 
    Html.div [
        Attr.children [
            Html.img [
                Attr.src (b64Image "my-image.png")
            ]
        ]
    ]

[<EntryPoint>]
let main args =
    Giraffe.DashApp.initDefault()
    |> Giraffe.DashApp.withLayout dslLayout
    |> Giraffe.DashApp.run args {HostName = "localhost"; LogLevel = LogLevel.Debug; ErrorHandler = ((fun ex ->  ex.Message) >> text)}