open Dash.NET.Giraffe
open Dash.NET.DashTable

let columns = [|
    DataTable.Column.init("No padding", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init())
    DataTable.Column.init("Padding 12", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(padding=Padding.Yes, paddingWidth=12u))
    DataTable.Column.init("Padding 9", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(padding=Padding.Yes).paddingWidth(9u))
    DataTable.Column.init("Padding 6", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init(specifier="06"))
|]

let values = [ 123; 123; 1234; 12345; 123456789 ]

let layout =
    DataTable.dataTable "datatable" [
        DataTable.Attr.columns columns
        DataTable.Attr.data (values |> List.map (fun v -> box {| a = v |}))
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
