open Dash.NET.Giraffe
open Dash.NET.DashTable

let columns = [|
    DataTable.Column.init("No groups", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper())
    DataTable.Column.init("Groups of 3", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper().group(true))
    DataTable.Column.init("Groups of 4", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(group=Group.Yes, groups=[ 4u ]))
    DataTable.Column.init("Groups of 2,3,2", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(group=Group.Yes).groups([ 2u; 3u; 2u ]))
|]

let values = [ 123; 123; 1234; 12345; 123456789 ]

let layout =
    DataTable.dataTable "datatable" [
        DataTable.Attr.columns columns
        DataTable.Attr.data (values |> List.map (fun v -> box {| a = v |}))
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
