open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET

let layout =
    Html.div [ 
        Attr.children [ 
            RangeSlider.rangeSlider "my-range-slider" [ 
                RangeSlider.Attr.min 0.0
                RangeSlider.Attr.max 20.0
                RangeSlider.Attr.step 0.5
                RangeSlider.Attr.value [ 5.0; 15.0 ] 
            ]
            Html.div [Attr.id "output-container-range-slider" ] 
        ] 
    ]

let callback =
    let output = "output-container-range-slider" @. Children
    Callback.singleOut (
        "my-range-slider" @. Value,
        output,
        (fun (value: float list) ->
            let label = $"You have selected \"{value}\""
            output => label
        )
    )

let externalStylesheets =
    [ "https://codepen.io/chriddyp/pen/bWLwgP.css" ]

[<EntryPoint>]
let main args =
    DashApp.initDefault ()
    |> DashApp.appendCSSLinks externalStylesheets
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
