open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET

let markers =
    [ 0.0 .. 4.0 ]
    |> Seq.map (fun x -> x, 10.0 ** x |> string |> RangeSlider.Mark.Value)
    |> Map.ofSeq

let layout =
    Html.div [ 
        Attr.children [ 
            RangeSlider.rangeSlider "non-linear-range-slider" [ 
                RangeSlider.Attr.marks markers
                RangeSlider.Attr.max 3.0
                RangeSlider.Attr.value [ 0.1; 2.0 ]
                RangeSlider.Attr.dots false
                RangeSlider.Attr.step 0.01
                RangeSlider.Attr.updatemode RangeSlider.UpdateOn.Drag 
            ] 
            Html.div[
                Attr.id "output-container-range-slider-non-linear"
                Attr.style [ Css.marginTop 20 ]
            ]
        ]
    ] 

let callback =
    let output = "output-container-range-slider-non-linear" @. Children
    Callback.singleOut (
        "non-linear-range-slider" @. Value,
        output,
        (fun (values: float list) ->
            let tValues =
                values
                |> Seq.map (fun x -> 10.0 ** x)
                |> Seq.toList
            let label =
                sprintf "Linear Value: %A, Log Value: [%.2f, %.2f]" values tValues.[0] tValues.[1]
            output => label
        )
    
let externalStylesheets = 
    [ "https://codepen.io/chriddyp/pen/bWLwgP.css" ]

[<EntryPoint>]
let main args =
    DashApp.initDefault ()
    |> DashApp.appendCSSLinks externalStylesheets
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
