let style1 =
    [ Css.color "#77b0b1" ]
    |> DashComponentStyle.fromCssStyle

let style2 =
    [ Css.color "#f50" ]
    |> DashComponentStyle.fromCssStyle

let marks = [ 
              (0.0, RangeSlider.StyledMarkValue.init ("0°C", style1) |> RangeSlider.Mark.StyledValue)
              (26.0, RangeSlider.StyledMarkValue.init ("26°C") |> RangeSlider.Mark.StyledValue)
              (37.0, RangeSlider.StyledMarkValue.init ("37°C") |> RangeSlider.Mark.StyledValue)
              (100.0, RangeSlider.StyledMarkValue.init ("100°C", style2) |> RangeSlider.Mark.StyledValue) 
            ] |> Map.ofList

let layout =
    RangeSlider.rangeSlider "my-range-slider" [
         RangeSlider.Attr.min 0.0
         RangeSlider.Attr.max 100.0
         RangeSlider.Attr.value [ 10.0; 65.0 ]
         RangeSlider.Attr.marks marks 
    ]
