open Dash.NET
open Dash.NET.DCC
open Dash.NET.Giraffe

let code = """```python
html.Div([
    dcc.Markdown(
        code,
        id="code",
        style={"width": 500, "height": 200, "overflow": "auto"},
    ),
    dcc.Clipboard(
        target_id="code",
        style={
            "position": "absolute",
            "top": 0,
            "right": 20,
            "fontSize": 20,
        },
    ),
], style={"width": 500, "height": 200, "position": "relative"})
```"""
let layout =
    Html.div [
        Attr.children [
            Markdown.markdown "code" [
                Markdown.Attr.children code
                Markdown.Attr.style [
                    StyleProperty ("width", 500)
                    StyleProperty ("height", 200)
                    StyleProperty ("overflow", "auto")
                ]
            ]
            Clipboard.clipboard "clipboard" [
                Clipboard.Attr.targetId "code"
                Clipboard.Attr.style [
                    StyleProperty ("position", "absolute")
                    StyleProperty ("top", 0)
                    StyleProperty ("right", 20)
                    StyleProperty ("fontSize", 20)
                ]
            ]
        ]
        Attr.style [
            StyleProperty ("width", 500)
            StyleProperty ("height", 200)
            StyleProperty ("position", "relative")
        ]
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
