open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Html.h6 [ 
                Attr.children "Change the value in the text box to see callbacks in action!" 
            ]
            Html.div [
                Attr.children [
                    Html.text "Input: "
                    Input.input "my-input" [
                        Input.Attr.value "initial value"
                        Input.Attr.inputType ComponentPropTypes.Text
                    ]
                ]
            ]
            Html.br []
            Html.div [
                Attr.id "my-output"
            ]
        ]
    ]

let updateOutputDivCallback =
    Callback.singleOut (
        "my-input" @. Value,
        "my-output" @. Children,
        fun (inputValue:string) -> 
            "my-output" @. Children => sprintf "Output: %s" inputValue
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updateOutputDivCallback
    |> DashApp.run args