open Dash.NET
open System

let dslLayout = 
    Html.div [
        Attr.children [
            Input.input "num-multi" [
                Input.Attr.inputType ComponentPropTypes.Number
                Input.Attr.value 5
            ]
            Html.table [
                Attr.children [
                    Html.tr [ 
                        Attr.children [
                            Html.td [ Attr.children [ Html.text "x"; Html.sup [ Attr.children 2 ] ] ]
                            Html.td [ Attr.id "square" ]
                        ]
                    ]
                    Html.tr [ 
                        Attr.children [
                            Html.td [ Attr.children [ Html.text "x"; Html.sup [ Attr.children 3 ] ] ]
                            Html.td [ Attr.id "cube" ]
                        ]
                    ]
                    Html.tr [ 
                        Attr.children [
                            Html.td [ Attr.children [ Html.text 2; Html.sup [ Attr.children "x" ] ] ]
                            Html.td [ Attr.id "twos" ]
                        ]
                    ]
                    Html.tr [ 
                        Attr.children [
                            Html.td [ Attr.children [ Html.text 3; Html.sup [ Attr.children "x" ] ] ]
                            Html.td [ Attr.id "threes" ]
                        ]
                    ]
                    Html.tr [ 
                        Attr.children [
                            Html.td [ Attr.children [ Html.text "x"; Html.sup [ Attr.children "x" ] ] ]
                            Html.td [ Attr.id "x^x" ]
                        ]
                    ]
                ]
            ]
        ]
    ]

let updateOutputTableCallback =
    Callback.multiOut (
        "num-multi" @. Value,
        [ "square" @. Children 
          "cube" @. Children
          "twos" @. Children
          "threes" @. Children
          "x^x" @. Children ],
        fun (inputValue: string) ->
            match Double.TryParse inputValue with
            | true, value -> 
                [ "square" @. Children => value ** 2.
                  "cube" @. Children => value ** 3.
                  "twos" @. Children => 2. ** value
                  "threes" @. Children => 3. ** value
                  "x^x" @. Children => value ** value ]
            | _ -> []
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updateOutputTableCallback
    |> DashApp.run args