open Dash.NET

let dslLayout = 
    Html.div [
        Attr.children [
            Input.input "input-1" [ 
                Input.Attr.inputType InputType.Text
                Input.Attr.value "Montreal" 
            ]
            Input.input "input-2" [ 
                Input.Attr.inputType InputType.Text
                Input.Attr.value "Canada" 
            ]
            Html.div [Attr.id "output-state"]
        ]
    ]

let setOutputDivValue =
    Callback.singleOut (
        [ "input-1" @. Value
          "input-2" @. Value ],
        "output-state" @. (CustomProperty "children"),
        fun input1 input2 -> 
            "output-state" @. (CustomProperty "children") 
                => sprintf "Input 1 is %s, Input 2 is %s" input1 input2
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback setOutputDivValue
    |> DashApp.run args