open Dash.NET
open System

let dslLayout = 
    Html.div [
        Attr.children [
            Html.button [ Attr.id "button_1"; Attr.children "Execute fast callback" ]
            Html.button [ Attr.id "button_2"; Attr.children "Execute slow callback" ]
            Html.div [ Attr.id "output_1"; Attr.children "callback not executed" ]
            Html.div [ Attr.id "output_2"; Attr.children "callback not executed" ]
            Html.div [ Attr.id "output_3"; Attr.children "callback not executed" ]
        ]
    ]

let updateFastCallback =
    Callback.singleOut (
        "button_1" @. (CustomProperty "n_clicks"),
        "output_1" @. Children,
        fun (nClicks: int) -> 
            let now = DateTimeOffset.Now
            "output_1" @. Children => sprintf "In the fast callback it is %s" (now.ToString())
    )

let updateSlowCallback =
    Callback.singleOut (
        "button_2" @. (CustomProperty "n_clicks"),
        "output_2" @. Children,
        fun (nClicks: int) -> 
            async { do! Async.Sleep 5000 } |> Async.RunSynchronously
            let now = DateTimeOffset.Now
            "output_2" @. Children => sprintf "In the slow callback it is %s" (now.ToString())
    )

let updateThirdCallback =
    Callback.singleOut (
        [ "output_1" @. Children 
          "output_2" @. Children ],
        "output_3" @. Children,
        fun (o1: obj) (o2: obj) -> 
            let now = DateTimeOffset.Now
            "output_3" @. Children => sprintf "In the third callback it is %s" (now.ToString())
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback updateFastCallback
    |> DashApp.addCallback updateSlowCallback
    |> DashApp.addCallback updateThirdCallback
    |> DashApp.run args